
// Copyright (c) 2003 Sonic Foundry, Inc. and Sonic Foundry 
// Media Systems, Inc. Neither this code nor any portion 
// thereof maybe reproduced, altered,or otherwise changed, 
// distributed or copied,without the express written 
// permission of Sonic Foundry. 
// All rights reserved.

// BEGINFILE WM7PlayerArea.js -------------------------------------------------------------------------- >

WM7PlayerArea.prototype = new WM64PlayerArea();
function WM7PlayerArea(container, containingWindow, ID)
{
	this.PlayerType = PlayerType.WM7;
	
	if (container && containingWindow && ID)
	{
		this.InitializeArea(container, containingWindow, ID);
	}
	
	this.LoadPlayerControl = function()
	{
		var objEmbeddedPlayer = this.GetEmbeddedPlayer();
		this.pci = new PlayerControlWM7(objEmbeddedPlayer);
	}
	
	this.SetPlayFrom = function(timeInSecs)
	{
		this.Debug("SetPlayFrom: " + timeInSecs);

		this.pci.SetPosition(timeInSecs);		
	}
	
}

// ENDFILE WM7PlayerArea.js ----------------------------------------------------------------------------->

// BEGINFILE PlayerControlWM7.js ------------------------------------------------------------------------->
function PlayerControlWM7(objEmbeddedPlayer)
{
	this.objEmbedded=objEmbeddedPlayer;
	
	this.GetVersionInfo = function()
	{
		return this.objEmbedded.versionInfo;
	}

	this.Play = function()
	{
		this.objEmbedded.controls.play();
	}
	
	this.Stop = function()
	{
		this.objEmbedded.controls.stop();
	}
	
	this.Pause = function()
	{
		this.objEmbedded.controls.pause();
	}

	this.GetPlayState = function()
	{
		return this.objEmbedded.playState;
	}
	
	this.SetFullScreen = function(f)
	{
		this.objEmbedded.fullScreen = f;
	}
	
	this.SetPosition = function(dPosition)
	{
		this.objEmbedded.controls.currentPosition=dPosition;
	}

	this.GetPosition = function()
	{
		return this.objEmbedded.controls.currentPosition;
	}
	
	this.GetMediaDuration = function()
	{
		if (this.objEmbedded.currentMedia)
		{
			return this.objEmbedded.currentMedia.duration;
		}
		
		return 0;
	}

	this.SetMedia = function(sMedia)
	{
		this.objEmbedded.URL=sMedia;
	}
	
	
	this.GetCurrentMarker = function()
	{
		return this.objEmbedded.controls.currentMarker;
	}
	
	this.GetMediaMarkerCount = function()
	{
		if (this.objEmbedded.currentMedia)
		{
			return this.objEmbedded.currentMedia.markerCount;
		}
		
		return 0;
	}
	
	this.GetMediaMarkerName = function(nIndex)
	{
		if (this.objEmbedded.currentMedia)
		{
			return this.objEmbedded.currentMedia.getMarkerName(nIndex);
		}
		
		return null;
	}
	
	this.GetMediaMarkerTime = function(nIndex)
	{
		if (this.objEmbedded.currentMedia)
		{
			return this.objEmbedded.currentMedia.getMarkerTime(nIndex);
		}
		
		return 0;
	}
	
	this.GetVolume = function()
	{
		return this.objEmbedded.settings.volume;
	}
	
	this.SetVolume = function(nVolume)
	{
		this.objEmbedded.settings.volume=nVolume;
	}
	
	this.SetMute = function(fMute)
	{
		this.objEmbedded.settings.mute=fMute;
	}
	
	this.GetMute = function()
	{
		return this.objEmbedded.settings.mute;
	}
		
}

// ENDFILE PlayerControlWM7.js --------------------------------------------------------------------------->
